// Copyright (c) Microsoft Corporation. All rights reserved.
// Script for ATL Controls

function OnPrep(selProj, selObj)
{
	var L_WizardDialogTitle_Text = "ATL ؼ";
	return PrepCodeWizard(selProj, L_WizardDialogTitle_Text);
}

function OnFinish(selProj, selObj)
{
	var oCM;
	try
	{
		oCM	= selProj.CodeModel;
		
		var bDevice = IsDeviceProject(selProj);
		wizard.AddSymbol("DEVICE", bDevice);
		
		// used only for device projects where platforms may not support DCOM.
		wizard.AddSymbol("SUPPORT_DCOM", false);
		wizard.AddSymbol("SUPPORT_NON_DCOM", false);

		var strShortName = wizard.FindSymbol("SHORT_NAME");
		var L_TRANSACTION_Text = " ATL ؼ ";
		oCM.StartTransaction(L_TRANSACTION_Text + strShortName);
		if(!AddATLSupportToProject(selProj))
		{
			oCM.AbortTransaction();
			return;
		}

		var bDLL;
		if (typeDynamicLibrary == selProj.Object.Configurations(1).ConfigurationType)
			bDLL = true;
		else
			bDLL = false;
		wizard.AddSymbol("DLL_APP", bDLL);

		var strProjectName		= wizard.FindSymbol("PROJECT_NAME");
		var strProjectPath		= wizard.FindSymbol("PROJECT_PATH");
		var strTemplatePath		= wizard.FindSymbol("TEMPLATES_PATH");
		var strUpperShortName	= CreateASCIIName(strShortName.toUpperCase());
		var strInterfaceName	= wizard.FindSymbol("INTERFACE_NAME");
		var strHTMLID 			= "IDH_" + strUpperShortName;
		var strDLGID  			= "IDD_" + strUpperShortName;
		wizard.AddSymbol("UPPER_SHORT_NAME", strUpperShortName);
		var strVIProgID			= wizard.FindSymbol("VERSION_INDEPENDENT_PROGID");
		if (strVIProgID == null || strVIProgID == "")
		{
			wizard.AddSymbol("PROGID_VALID", false);
			wizard.AddSymbol("VERSION_INDEPENDENT_PROGID","");
			wizard.AddSymbol("PROGID","");
		}
		else
		{
			wizard.AddSymbol("PROGID_VALID", true);
			wizard.AddSymbol("PROGID", strVIProgID.substr(0,37) + ".1");
		}
		var bConnectionPoint	= wizard.FindSymbol("CONNECTION_POINTS");
 		var strClassName		= wizard.FindSymbol("CLASS_NAME");
		var strHeaderFile		= wizard.FindSymbol("HEADER_FILE");
		var strImplFile			= wizard.FindSymbol("IMPL_FILE");
		var strCoClass			= wizard.FindSymbol("COCLASS");
		var bAttributed			= wizard.FindSymbol("ATTRIBUTED");

		var bHTMLCtl			= wizard.FindSymbol("HTML_CONTROL");
		var bCompositeCtl		= wizard.FindSymbol("COMPOSITE_CONTROL");

		var strProjectRC		= GetProjectFile(selProj, "RC", true, false);
		var strProjectIDL		= GetProjectFile(selProj, "IDL", false, false);

		if (strProjectRC == "")
		{
			var L_MissingResourceError = "Your have to add a resource file to your project before you can add ATL Controls to it";
			wizard.ReportError(L_MissingResourceError);
			return;
		}
		// Create necessary GUIDS
		CreateGUIDs();

		if (!bAttributed)
		{
			var MidlTool = GetIDLConfig(selProj,true);
			var strMidlHeader = MidlTool.HeaderFileName;
			strMidlHeader = selProj.Object.Configurations(1).Evaluate(strMidlHeader);
			wizard.AddSymbol("MIDL_H_FILENAME",strMidlHeader);
		}

		SetResDlgFont();

		if (!bDevice)
		{
			// open resource file
			var oResHelper = wizard.ResourceHelper;
			oResHelper.OpenResourceFile(strProjectRC);

			// Add Bitmap resource
			var strBitmapFile = GetUniqueFileName(strProjectPath, strShortName + ".bmp");
			var strBMPID = "IDB_" + strUpperShortName;
			wizard.RenderTemplate(strTemplatePath + "\\" + "toolbar.bmp", strProjectPath + strBitmapFile, true); //don't process bitmap
			var strNameAndID = oResHelper.AddResource(strBMPID, strProjectPath + strBitmapFile, "BITMAP");
			if (strNameAndID == null) return;
			var nEqualPos = strNameAndID.indexOf("=");
			var strSymbolName = strNameAndID.substr(0, nEqualPos);
			var strSymbolID = strNameAndID.substr(nEqualPos + 1);
			wizard.AddSymbol("IDR_BMPID_VALUE", strSymbolID);

			if (!bAttributed)
			{
				// Get LibName
				wizard.AddSymbol("LIB_NAME", oCM.IDLLibraries(1).Name);

				// Get LibID
				var oUuid = oCM.IDLLibraries(1).Attributes.Find("uuid");
				if (oUuid)
					wizard.AddSymbol("LIBID_REGISTRY_FORMAT", oUuid.Value);

				// Get typelib version
				var oVersion = oCM.IDLLibraries(1).Attributes.Find("version");
				if (oVersion)
				{
					var aryMajorMinor = oVersion.Value.split('.');
					for (var nCntr=0; nCntr<aryMajorMinor.length; nCntr++)
					{
						if (nCntr == 0)
							wizard.AddSymbol("TYPELIB_VERSION_MAJOR", aryMajorMinor[nCntr]);
						else
							wizard.AddSymbol("TYPELIB_VERSION_MINOR", aryMajorMinor[nCntr]);
					}
				}

				// Get AppID
				var strAppID = wizard.GetAppID();
				if (strAppID.length > 0)
				{
					wizard.AddSymbol("APPID_EXIST", true);
					wizard.AddSymbol("APPID_REGISTRY_FORMAT", strAppID);
				}

				// add RGS file resource
				var strRGSFile = GetUniqueFileName(strProjectPath, CreateASCIIName(strShortName) + ".rgs");
				
				var strRGSID = "IDR_" + strUpperShortName;
				RenderAddTemplate(wizard, "control.rgs", strRGSFile, false, false);
				var strSymbolValue = oResHelper.AddResource(strRGSID, strProjectPath + strRGSFile, "REGISTRY");
				if (strSymbolValue == null) return;				
				wizard.AddSymbol("RGS_ID", strSymbolValue.split("=").shift());

				// Add connection point support
				if (bConnectionPoint)
					RenderAddTemplate(wizard, "connpt.h", "_" + strInterfaceName + "Events_CP.h", selObj, false);

				// Add #include "olectl.h" to strProject.idl
				if (!DoesIncludeExist(selProj, '"olectl.h"', strProjectIDL))
					oCM.AddInclude('"olectl.h"', strProjectIDL, vsCMAddPositionEnd);

				// Render ctlco.idl and insert into strProject.idl
				AddCoclassFromFile(oCM, "ctlco.idl");

				// Render ctlint.idl and insert into strProject.idl
				AddInterfaceFromFile(oCM, "ctlint.idl");

				SetMergeProxySymbol(selProj);
			}

			if (bHTMLCtl)
			{
				var strHTMLFile = GetUniqueFileName(strProjectPath, strShortName + "UI.htm");
				RenderAddTemplate(wizard, "HTMLCTL.htm", strHTMLFile, false, false);
				var strSymbolValue = oResHelper.AddResource(strHTMLID, strProjectPath + strHTMLFile, "HTML");
				if (strSymbolValue == null) return;								
				wizard.AddSymbol("IDH_HTMLID", strSymbolValue.split("=").shift());
			}

			if (bCompositeCtl)
			{				
				var strRCTemplFile = strTemplatePath + "\\cmposite.rc";
				var strTemporaryResourceFile = RenderToTemporaryResourceFile(strRCTemplFile);
				var strSymbolValue = oResHelper.AddResource(strDLGID, strTemporaryResourceFile, "DIALOG");
				if (strSymbolValue == null) return;				
				wizard.AddSymbol("IDD_DIALOGID", strSymbolValue.split("=").shift());
			}
			
			// Add header
			RenderAddTemplate(wizard, "control.h", strHeaderFile, selObj, true);	

			// Add HTML
			var strHTMLFile = GetUniqueFileName(strProjectPath, strShortName + ".htm");
			RenderAddTemplate(wizard, "default.htm", strHTMLFile, selObj, false);

			// Add CPP
			RenderAddTemplate(wizard, "control.cpp", strImplFile, selObj, false);

			// close resource file
			oResHelper.CloseResourceFile();
		}
		else
		{
		
			var bFirst = true;

			var oUuid;
			var oVersion;
			var aryMajorMinor;
			var strAppID;
			// add RGS file resource
			var strRGSFile = GetUniqueFileName(strProjectPath, CreateASCIIName(strShortName) + ".rgs");
			var strRGSDCOMFile = GetUniqueFileName(strProjectPath, CreateASCIIName(strShortName + "DCOM") + ".rgs");
			var strRGSID = "IDR_" + strUpperShortName;
			var strRGSDCOMID = "IDR_" + strUpperShortName + "DCOM";
			var strHTMLFile;
			var bDeviceDCOM = ProjectContainsDCOMPlatform(selProj)
			var bDeviceNonDCOM = ProjectContainsNonDCOMPlatform(selProj)

			if (!bAttributed)
			{
				// Get LibName
				wizard.AddSymbol("LIB_NAME", oCM.IDLLibraries(1).Name);

				// Get LibID
				oUuid = oCM.IDLLibraries(1).Attributes.Find("uuid");
				if (oUuid)
					wizard.AddSymbol("LIBID_REGISTRY_FORMAT", oUuid.Value);

				// Get typelib version
				oVersion = oCM.IDLLibraries(1).Attributes.Find("version");
				if (oVersion)
				{
					aryMajorMinor = oVersion.Value.split('.');
					for (var nCntr=0; nCntr<aryMajorMinor.length; nCntr++)
					{
						if (nCntr == 0)
							wizard.AddSymbol("TYPELIB_VERSION_MAJOR", aryMajorMinor[nCntr]);
						else
							wizard.AddSymbol("TYPELIB_VERSION_MINOR", aryMajorMinor[nCntr]);
					}
				}

				// Get AppID
				var strAppID = wizard.GetAppID();
				if (strAppID.length > 0)
				{
					wizard.AddSymbol("APPID_EXIST", true);
					wizard.AddSymbol("APPID_REGISTRY_FORMAT", strAppID);
				}
			}
			if (bHTMLCtl)
			{
				strHTMLFile = GetUniqueFileName(strProjectPath, strShortName + "UI.htm");
				RenderAddTemplate(wizard, "HTMLCTL.htm", strHTMLFile, false, false);
			}

			if (bDeviceNonDCOM)
			{
				wizard.AddSymbol("SUPPORT_NON_DCOM", true);
				RenderAddTemplate(wizard, "control.rgs", strRGSFile, false, false);
				wizard.AddSymbol("SUPPORT_NON_DCOM", false);

			}
			if (bDeviceDCOM)
			{
				wizard.AddSymbol("SUPPORT_DCOM", true);
				RenderAddTemplate(wizard, "control.rgs", strRGSDCOMFile, false, false);
				wizard.AddSymbol("SUPPORT_DCOM", false);	
			}

			var configs = selProj.Object.Configurations;
			var completedResourceFiles = new Array();
			AddDeviceSymbols(false);
			wizard.AddSymbol("SUPPORT_NON_DCOM", bDeviceNonDCOM);
			wizard.AddSymbol("SUPPORT_DCOM", bDeviceDCOM);

			var ProjWiz = new ActiveXObject("ProjWiz.SDProjWiz2.4");
			var oResHelper = wizard.ResourceHelper;

			for (var nCntr = 1; nCntr <= configs.Count; nCntr++)
			{
				var config = configs.Item(nCntr);
				var strCurrentResource = GetDeviceResourceFileForConfig(config);

				if (completedResourceFiles.join(";").indexOf(strCurrentResource) == -1)
				{
					// open resource file
					oResHelper.OpenResourceFile(strCurrentResource);

					if (!bAttributed)
					{
						// TODO: add checks that verify the RGS ID is the same across all .rc/.h files...
						// add RGS file resource
						if (bFirst)
						{
							if (bDeviceNonDCOM)
							{
								var strSymbolValue = oResHelper.AddResource(strRGSID, strProjectPath + strRGSFile, "REGISTRY");					
								if (strSymbolValue == null) return;											
								wizard.AddSymbol("RGS_ID", strSymbolValue.split("=").shift());
							}
							if (bDeviceDCOM)
							{
								var strSymbolValue = oResHelper.AddResource(strRGSDCOMID, strProjectPath + strRGSDCOMFile, "REGISTRY");					
								if (strSymbolValue == null) return;											
								wizard.AddSymbol("RGSDCOM_ID", strSymbolValue.split("=").shift());	
							}
							// Add connection point support
							if (bConnectionPoint)
								RenderAddTemplate(wizard, "connpt.h", "_" + strInterfaceName + "Events_CP.h", selObj, false);

							// Add #include "olectl.h" to strProject.idl
							if (!DoesIncludeExist(selProj, '"olectl.h"', strProjectIDL))
								oCM.AddInclude('"olectl.h"', strProjectIDL, vsCMAddPositionEnd);

							// Render ctlco.idl and insert into strProject.idl
							AddCoclassFromFile(oCM, "ctlco.idl");

							// Render ctlint.idl and insert into strProject.idl
							AddInterfaceFromFile(oCM, "ctlint.idl");

							SetMergeProxySymbol(selProj);
						}
						else
						{
							// See above TODO
							if (bDeviceNonDCOM)
							{
							    var strSymbolValue = oResHelper.AddResource(strRGSID, strProjectPath + strRGSFile, "REGISTRY");
							    if (strSymbolValue == null) return;
							}
							if (bDeviceDCOM)
							{
							    var strSymbolValue = oResHelper.AddResource(strRGSDCOMID, strProjectPath + strRGSDCOMFile, "REGISTRY");
							    if (strSymbolValue == null) return;
							}		
						}

					}

					if (bHTMLCtl)
					{
						if (bFirst)
						{
							var strSymbolValue = oResHelper.AddResource(strHTMLID, strProjectPath + strHTMLFile, "HTML");
							if (strSymbolValue == null) return;				
							wizard.AddSymbol("IDH_HTMLID", strSymbolValue.split("=").shift());
						}
						else
						{
							// See above TODO
							var strSymbolValue = oResHelper.AddResource(strHTMLID, strProjectPath + strHTMLFile, "HTML");
							if (strSymbolValue == null) return;				
						}
					}

					var strCurrentSymbol = GetDeviceSymbolForConfig(config);
					wizard.AddSymbol(strCurrentSymbol, true);
					
					if (bCompositeCtl)
					{
						var platformName = config.Platform.Name;
						var symbol = ProjWiz.GetBaseNativePlatformProperty(platformName, "UISymbol");

						var strRCTemplFile = strTemplatePath;
						if (symbol == "POCKETPC2003_UI_MODEL")
						{
							 strRCTemplFile += "\\cmpositeppc.rc";
						}
						else if (symbol == "SMARTPHONE2003_UI_MODEL")
						{
							 strRCTemplFile += "\\cmpositesp.rc";
						}
						else
						{
							 strRCTemplFile += "\\cmpositece.rc";
						}
						
						var strTemporaryResourceFile =  RenderToTemporaryResourceFile(strRCTemplFile);
						if (bFirst)
						{
							var strSymbolValue = oResHelper.AddResource(strDLGID, strTemporaryResourceFile, "DIALOG");
							if (strSymbolValue == null) return;				
							wizard.AddSymbol("IDD_DIALOGID", strSymbolValue.split("=").shift());
						}
						else
						{
							// see above TODO
							var strSmybolValue = oResHelper.AddResource(strDLGID, strTemporaryResourceFile, "DIALOG");
							if (strSymbolValue == null) return;				
						}
					}
					// close resource file
					oResHelper.CloseResourceFile();
					completedResourceFiles.push(strCurrentResource);
				}				
				bFirst = false;
			}
            // Add header
			RenderAddTemplate(wizard, "control.h", strHeaderFile, selObj, true);	

			// Add HTML
			var strHTMLFile = GetUniqueFileName(strProjectPath, strShortName + ".htm");
			RenderAddTemplate(wizard, "default.htm", strHTMLFile, selObj, false);

			// Add CPP
			RenderAddTemplate(wizard, "control.cpp", strImplFile, selObj, false);
		}

		oCM.CommitTransaction();

		var newClass = oCM.Classes.Find(strClassName);
		if(newClass)
			newClass.StartPoint.TryToShow(vsPaneShowTop);
	}
	catch(e)
	{
		if (oCM)
			oCM.AbortTransaction();

		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function CreateGUIDs()
{
	try
	{	
		// create CLSID
		var strRawGUID = wizard.CreateGuid();
		var strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
		wizard.AddSymbol("CLSID_REGISTRY_FORMAT", strFormattedGUID);

		// create interface GUID
		strRawGUID = wizard.CreateGuid();
		strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
		wizard.AddSymbol("INTERFACE_IID", strFormattedGUID);

		// create connection point GUID
		var bConnectionPoint = wizard.FindSymbol("CONNECTION_POINTS");
		if (bConnectionPoint)
		{
			strRawGUID = wizard.CreateGuid();
			strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
			wizard.AddSymbol("CONNECTION_POINT_IID", strFormattedGUID);
		}

		// create GUID for HTML dispatch interface
		var bHTMLCtl = wizard.FindSymbol("HTML_CONTROL");
		if (bHTMLCtl)
		{
			strRawGUID = wizard.CreateGuid();
			strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
			wizard.AddSymbol("INTERFACEUI_IID", strFormattedGUID);
	
			// create GUID for HTML coclass
			var bAttributed = wizard.FindSymbol("ATTRIBUTED");
			if (bAttributed)
			{
				strRawGUID = wizard.CreateGuid();
				strFormattedGUID = wizard.FormatGuid(strRawGUID, 0);
				wizard.AddSymbol("OBJECT_UI_GUID", strFormattedGUID);				
			}
		}
	}
	catch(e)
	{
		throw e;
	}
}

// SIG // Begin signature block
// SIG // MIIkRQYJKoZIhvcNAQcCoIIkNjCCJDICAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // FjlPT3teOTce3W26qjP+/2EBbWcXTPGTi2ednXjy8I6g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFgowghYGAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggfcwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIDuZ8yyhrB9O7xfEQ4K9k6wzxNWvmrV9a5Repiyw
// SIG // h3RSMIGKBgorBgEEAYI3AgEMMXwweqBggF4AZABlAGYA
// SIG // YQB1AGwAdABfAGMANwA5ADcAMwA0ADEAZAAtADkAZgBi
// SIG // ADIALQA0ADUAZQBiAC0AOQBhADIAMAAtADYAZAAxAGUA
// SIG // MQA1AGIAYQAyAGIANwA4AC4AagBzoRaAFGh0dHA6Ly9t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBALkw
// SIG // E80Ocp12aP0T+xiiEJPBq4cQkAK0C1jpgEz/RQArGkP3
// SIG // xansLd+grBXz3gypXIguUB9yJ24JnqjI6P7/LlTLTO24
// SIG // i0cn9mjAeJpk3k+tmxC1QIfNIYdhA7Xt4D2qzEuaUm/g
// SIG // 6exaWHO3QVdgltwAHZNvQZPhww6OIexM8iQ5bKbjd6yV
// SIG // thpncToq2PFntGNATrHZHw0mUelF4BOwVZWYauUftLHx
// SIG // WDjxEkcLx7ZZe5h1mCl/U3pb+bWL0RJdiNvLNgFsSxy+
// SIG // tLzIagJ2RSro59BVvct3QkMg6tgIDa4j5SMCyuZZFxXQ
// SIG // 7qaL/dk5Vc4OHU5ZsogXen1oks6P7SGhghNLMIITRwYK
// SIG // KwYBBAGCNwMDATGCEzcwghMzBgkqhkiG9w0BBwKgghMk
// SIG // MIITIAIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBOwYLKoZI
// SIG // hvcNAQkQAQSgggEqBIIBJjCCASICAQEGCisGAQQBhFkK
// SIG // AwEwMTANBglghkgBZQMEAgEFAAQgHA1eKXzwJDc27pfT
// SIG // TxcGP7a8LE6fkdQ9QFG1Qv7aRTQCBliXjfBIIBgRMjAx
// SIG // NzAyMDkwNDE5MjAuMVowBwIBAYACAfSggbmkgbYwgbMx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIx
// SIG // JzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo1ODQ3LUY3
// SIG // NjEtNEY3MDElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUt
// SIG // U3RhbXAgU2VydmljZaCCDtAwggZxMIIEWaADAgECAgph
// SIG // CYEqAAAAAAACMA0GCSqGSIb3DQEBCwUAMIGIMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQg
// SIG // Um9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAxMDAe
// SIG // Fw0xMDA3MDEyMTM2NTVaFw0yNTA3MDEyMTQ2NTVaMHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqR0NvHcRijog
// SIG // 7PwTl/X6f2mUa3RUENWlCgCChfvtfGhLLF/Fw+Vhwna3
// SIG // PmYrW/AVUycEMR9BGxqVHc4JE458YTBZsTBED/FgiIRU
// SIG // QwzXTbg4CLNC3ZOs1nMwVyaCo0UN0Or1R4HNvyRgMlhg
// SIG // RvJYR4YyhB50YWeRX4FUsc+TTJLBxKZd0WETbijGGvmG
// SIG // gLvfYfxGwScdJGcSchohiq9LZIlQYrFd/XcfPfBXday9
// SIG // ikJNQFHRD5wGPmd/9WbAA5ZEfu/QS/1u5ZrKsajyeioK
// SIG // MfDaTgaRtogINeh4HLDpmc085y9Euqf03GS9pAHBIAmT
// SIG // eM38vMDJRF1eFpwBBU8iTQIDAQABo4IB5jCCAeIwEAYJ
// SIG // KwYBBAGCNxUBBAMCAQAwHQYDVR0OBBYEFNVjOlyKMZDz
// SIG // Q3t8RhvFM2hahW1VMBkGCSsGAQQBgjcUAgQMHgoAUwB1
// SIG // AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fO
// SIG // mhjEMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwu
// SIG // bWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01p
// SIG // Y1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEF
// SIG // BQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cu
// SIG // bWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2Vy
// SIG // QXV0XzIwMTAtMDYtMjMuY3J0MIGgBgNVHSABAf8EgZUw
// SIG // gZIwgY8GCSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYx
// SIG // aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2Nz
// SIG // L0NQUy9kZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIg
// SIG // HQBMAGUAZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABh
// SIG // AHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEAB+aIUQ3ixuCYP4FxAz2do6Ehb7Prpsz1Mb7PBeKp
// SIG // /vpXbRkws8LFZslq3/Xn8Hi9x6ieJeP5vO1rVFcIK1GC
// SIG // RBL7uVOMzPRgEop2zEBAQZvcXBf/XPleFzWYJFZLdO9C
// SIG // EMivv3/Gf/I3fVo/HPKZeUqRUgCvOA8X9S95gWXZqbVr
// SIG // 5MfO9sp6AG9LMEQkIjzP7QOllo9ZKby2/QThcJ8ySif9
// SIG // Va8v/rbljjO7Yl+a21dA6fHOmWaQjP9qYn/dxUoLkSbi
// SIG // OewZSnFjnXshbcOco6I8+n99lmqQeKZt0uGc+R38ONiU
// SIG // 9MalCpaGpL2eGq4EQoO4tYCbIjggtSXlZOz39L9+Y1kl
// SIG // D3ouOVd2onGqBooPiRa6YacRy5rYDkeagMXQzafQ732D
// SIG // 8OE7cQnfXXSYIghh2rBQHm+98eEA3+cxB6STOvdlR3jo
// SIG // +KhIq/fecn5ha293qYHLpwmsObvsxsvYgrRyzR30uIUB
// SIG // HoD7G4kqVDmyW9rIDVWZeodzOwjmmC3qjeAzLhIp9cAv
// SIG // VCch98isTtoouLGp25ayp0Kiyc8ZQU3ghvkqmqMRZjDT
// SIG // u3QyS99je/WZii8bxyGvWbWu3EQ8l1Bx16HSxVXjad5X
// SIG // wdHeMMD9zOZN+w2/XU/pnR4ZOC+8z1gFLu8NoFA12u8J
// SIG // JxzVs341Hgi62jbb01+P3nSISRIwggTaMIIDwqADAgEC
// SIG // AhMzAAAAszm71BKTFan+AAAAAACzMA0GCSqGSIb3DQEB
// SIG // CwUAMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMT
// SIG // HU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMB4X
// SIG // DTE2MDkwNzE3NTY1OFoXDTE4MDkwNzE3NTY1OFowgbMx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIx
// SIG // JzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo1ODQ3LUY3
// SIG // NjEtNEY3MDElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUt
// SIG // U3RhbXAgU2VydmljZTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAJ42eXjeuC/MHUn9fikiWJr2Ylp7
// SIG // yzldveklaHAmd8soj1xvNY6raNcUqYB4Ag9qssERi19k
// SIG // p2s7RBL3l4qWhD3fqn9haaKIBs4J9InmhmZBhJQzwdYi
// SIG // 81RYANo9Xv6wo4mmZ+yNPW7TLIF/aIvd5UhMQ8kObht+
// SIG // DQLGugVqWwLUDnsrDfOqV5OcEkPxBfJYLY741QZMTcbL
// SIG // K1G8yWSE8PaVapWwM1hT1A5udRUivrizzWBbBA0JXphd
// SIG // AAsLAHFyd6YR4jLQ07bdqlUFg8aHQXw+GuoiFBAc6M7w
// SIG // kq7L+4x3oevEx9798fA8EDGm8H0SyGZalbEjJss19jQY
// SIG // S6kiubUCAwEAAaOCARswggEXMB0GA1UdDgQWBBTTXe3W
// SIG // W0qpaL5VZmRJh3PrF/AicDAfBgNVHSMEGDAWgBTVYzpc
// SIG // ijGQ80N7fEYbxTNoWoVtVTBWBgNVHR8ETzBNMEugSaBH
// SIG // hkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0w
// SIG // MS5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAC
// SIG // hj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2Nl
// SIG // cnRzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNydDAM
// SIG // BgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoGCCsGAQUFBwMI
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQAiV3ujVO9S7REMoDNF
// SIG // 5DZ9GHJuELMAz2V1Gfb1gosbquVJTEFce/9AO2gRa5aT
// SIG // VAVw4WzKAGNwOGsyzMybI8qI3yM7JHBDk1ni7fmpVW+n
// SIG // wxMgxQ5BMRwJphXdRltC6YUZwXWzVpn8cIleq9uuypII
// SIG // L6EbTwICbjhvtuDzaVDfnizJvMclLGnZtSavxDDupLOI
// SIG // wWu27IcS7eQUcgLEY2LBAOfKnLoTzZ55Q7imoSF7i16l
// SIG // FvrVXFKOK2Mg1Rsi4EJhVVnwkNXLc7W6B3p3aW2Y1zeZ
// SIG // a1nbbt7vqGC0NM9t0mZUUwyKmuAiEIzAwzCZ3eQ5MuSL
// SIG // mNoqNiD5TBlmzynLoYIDeTCCAmECAQEwgeOhgbmkgbYw
// SIG // gbMxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1P
// SIG // UFIxJzAlBgNVBAsTHm5DaXBoZXIgRFNFIEVTTjo1ODQ3
// SIG // LUY3NjEtNEY3MDElMCMGA1UEAxMcTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgU2VydmljZaIlCgEBMAkGBSsOAwIaBQAD
// SIG // FQC++cH02g8VP/CQAwO+eKWa2orcuaCBwjCBv6SBvDCB
// SIG // uTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBOVFMgRVNOOjRERTkt
// SIG // MEM1RS0zRTA5MSswKQYDVQQDEyJNaWNyb3NvZnQgVGlt
// SIG // ZSBTb3VyY2UgTWFzdGVyIENsb2NrMA0GCSqGSIb3DQEB
// SIG // BQUAAgUA3EXMTjAiGA8yMDE3MDIwODE2NTY0NloYDzIw
// SIG // MTcwMjA5MTY1NjQ2WjB3MD0GCisGAQQBhFkKBAExLzAt
// SIG // MAoCBQDcRcxOAgEAMAoCAQACAhJfAgH/MAcCAQACAhmu
// SIG // MAoCBQDcRx3OAgEAMDYGCisGAQQBhFkKBAIxKDAmMAwG
// SIG // CisGAQQBhFkKAwGgCjAIAgEAAgMW42ChCjAIAgEAAgMH
// SIG // oSAwDQYJKoZIhvcNAQEFBQADggEBAF3lQ3ZqLs5iAy6h
// SIG // IY4twbGxL2u8laxwaX3GCGXgZ+BqK32Cu4LyFV2bYz4w
// SIG // Xa9UNrNUeb5XwYelD6A5yKq/fkBpkrIPobB+tIySkTb2
// SIG // n7urStJPV/lxhBXLmvyLAHvIPcJhybYEdLd0uJtufVYk
// SIG // ZVPzPHYdb766EDL7MRE5YXxo8chKzs6doWtRH9Mi4dce
// SIG // zU3fl8d+hcqn8j8vudGmV7LuPbJN9Ipu+/Y3BamtRiW9
// SIG // HCjF0P85MgXaAe7wmxOhZd1brK5VYrjHsmPUPb6ApPKe
// SIG // PFmDCyCGc9ru1/z008lO1Lo/iJpz7lCIL2s1RfCo9SOS
// SIG // 75zXgfw1aZHnve7PyEUxggL1MIIC8QIBATCBkzB8MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAALM5u9QS
// SIG // kxWp/gAAAAAAszANBglghkgBZQMEAgEFAKCCATIwGgYJ
// SIG // KoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMC8GCSqGSIb3
// SIG // DQEJBDEiBCAcA5xU0Wu+tqT8ivO4Jj691wyUg3c0bbAs
// SIG // WrNxk1gB4DCB4gYLKoZIhvcNAQkQAgwxgdIwgc8wgcww
// SIG // gbEEFL75wfTaDxU/8JADA754pZraity5MIGYMIGApH4w
// SIG // fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACz
// SIG // ObvUEpMVqf4AAAAAALMwFgQUtY2d4x2DjYB3B5UUCGDR
// SIG // hRdc5q4wDQYJKoZIhvcNAQELBQAEggEAb74dbjDvwwLl
// SIG // tfJ3rE6sNZaHrGkuorw1m64LIb+kA1rF+keynr26qXqg
// SIG // e+xsSDzH6hxKzMFr1wGEXNLS+1ngLajR1ZgKuA2Zi1B9
// SIG // w7az/DVd4ENyqq6nIIr0vI/1G2S8NJnLIFw6oy/jbv4m
// SIG // IsK4i6YSm9JhrWZ9c6IEZO3S3/xp8yXfStZ1jbio19K6
// SIG // KjKPmrKMlpHwMjDd8ba4FrQ8lZ7jqiM/arv1BLiLQ+LR
// SIG // yWI9IjCAAM7ApCGi4f2hxxjL4AiCoFnmz8L+8Nfyv5aQ
// SIG // LM7TDXWdId6/N9x6PYfh3QKgmbRfegzi+Zd+1Gcge0lF
// SIG // z3kK5QW8VoZ8KmuubtL/Gw==
// SIG // End signature block
